function trigger_box(block)
% Level-2 M file S-Function for unit delay demo.
%   Copyright 1990-2009 The MathWorks, Inc.
%   $Revision: 1.1.6.1 $ 

  setup(block);
  
%endfunction

function setup(block)
  
  block.NumDialogPrms  = 1;
 
  
  %% Register number of input and output ports
  block.NumInputPorts  = 4;
  block.NumOutputPorts = 1;

  %% Setup functional port properties to dynamically
  %% inherited.
  block.SetPreCompInpPortInfoToDynamic;
  block.SetPreCompOutPortInfoToDynamic;
 
  block.InputPort(1).Dimensions        = 1;
  block.InputPort(2).Dimensions        = 1;
  block.InputPort(3).Dimensions        = 1;
  block.InputPort(4).Dimensions        = 4;
  block.InputPort(1).DirectFeedthrough = false;
  block.InputPort(2).DirectFeedthrough = false;
  block.InputPort(3).DirectFeedthrough = false;
  block.OutputPort(1).Dimensions       = 1;
  
  %% Set block sample time to inherited
  
  block.SampleTimes = [0.01 0];
  
  %% Set the block simStateCompliance to default (i.e., same as a built-in block)
  block.SimStateCompliance = 'DefaultSimState';
  

  %% Register methods
  block.RegBlockMethod('PostPropagationSetup',    @DoPostPropSetup);
  block.RegBlockMethod('InitializeConditions',    @InitConditions);  
  block.RegBlockMethod('Outputs',                 @Output);  
  block.RegBlockMethod('Update',                  @Update);  
  

  
%endfunction

function DoPostPropSetup(block)

  %% Setup Dwork
  block.NumDworks = 1;
  block.Dwork(1).Name = 'state'; 
  block.Dwork(1).Dimensions      =3;
  block.Dwork(1).DatatypeID      = 0;
  block.Dwork(1).Complexity      = 'Real';
  block.Dwork(1).UsedAsDiscState = true;

%endfunction

function InitConditions(block)

  %% Initialize Dwork
  n = block.Dwork(1).Dimensions;
  block.Dwork(1).Data(1) = 0;       %output state active
  block.Dwork(1).Data(2) = 1;       %latch state active
  block.Dwork(1).Data(3) = 0;       %timer state 0 = inactive
                                    % > 0 active.
  
  
%endfunction

function Output(block)

  output_state = block.Dwork(1).Data(1);
  block.OutputPort(1).Data = output_state;
 
 
%endfunction

function Update(block)
    load_priority = block.DialogPrm(1).Data;
    output_state  = block.Dwork(1).Data(1);
    latch_state   = block.Dwork(1).Data(2);
    timer_state   = block.Dwork(1).Data(3);
    reset_input   = block.InputPort(1).Data;
    current_input = block.InputPort(2).Data;
    voltage_input = block.InputPort(3).Data;
    freq_input_A    = block.InputPort(4).Data(1);
    freq_input_B    = block.InputPort(4).Data(2);
    freq_input_C    = block.InputPort(4).Data(3);
    freq_input_D    = block.InputPort(4).Data(4);
    
    %service timer
    if (timer_state>0)
        timer_state=timer_state-1;
        if(timer_state==0)&(freq_input_C==1)  
            %active timer expired and freq still greater than 59.9
            %reset latch and reconnect
            latch_state=0;
            output_state=1;
        end;
    end;
    
    %reset signal forces reconnect and clears latch
    if (latch_state==1)&(reset_input==1)
        latch_state  = 0;
        output_state = 1;
    end;
    
    %if frequency is greater than 59.9, then start reconnection logic
    if (timer_state==0)&(latch_state==1)&(output_state==0)&(freq_input_C==1)
        timer_state=25;   %start timer
    end;
        
    
    %over current condition triggers disconnect and sets latch
    if(latch_state==0)&(current_input==1)&(output_state==1)
        latch_state  = 1;
        output_state = 0;
    end;
    
    %under voltage condition triggers disconnect and sets latch
    if(latch_state==0)&(voltage_input==1)&(output_state==1)
        latch_state=1;
        output_state=0;
    end;
    
    %switch based on load priority
    %1 = critical load (drop if freq drops below 59.5 Hz
    %2 = non-critical lod (drop if freq drops below 59.8 Hz)
    
    switch load_priority
        case {1}
            if(latch_state==0)&(freq_input_B==1)&(output_state==1)
                latch_state=1;
                output_state=0;
            end;
            
        case {2}
            if(latch_state==0)&(freq_input_A==1)&(output_state==1)
                latch_state=1;
                output_state=0;
            end;
    end;
    
    
    
%     if(latch_state==0)&(freq_input_A==1)&(output_state==1)
%         latch_state  = 1;
%         output_state = 0;
%     end;
    
    block.Dwork(1).Data(1)=output_state;
    block.Dwork(1).Data(2)=latch_state;
    block.Dwork(1).Data(3)=timer_state;
    
  
%endfunction

