function Power_Dispatcher(block)
%Level-2 M file S-function for power dispatch in Odyssian demo
%

setup(block)

function setup(block)
    block.NumDialogPrms = 0;
    
    block.NumInputPorts = 3;
    block.NumOutputPorts = 1;
    
    block.SetPreCompInpPortInfoToDynamic;
    block.SetPreCompOutPortInfoToDynamic;
    
    block.InputPort(1).Dimensions        = 1;
    block.InputPort(1).DirectFeedthrough = false;
    block.InputPort(2).Dimensions        = 3;
    block.InputPort(2).DirectFeedthrough = false;
    block.InputPort(3).Dimensions        = 3;
    block.InputPort(3).DirectFeedthrough = false;
    
    block.OutputPort(1).Dimensions       = 3;
   
    
    %Set block sample time 0.1 seconds
    
    block.SampleTimes = [0.1 0];
    
    block.SimStateCompliance = 'DefaultSimState';
    
    %%register methods
    block.RegBlockMethod('PostPropagationSetup',    @DoPostPropSetup);
    block.RegBlockMethod('InitializeConditions',    @InitConditions);
    block.RegBlockMethod('Outputs',                 @Output);
    block.RegBlockMethod('Update',                  @Update);
    
%endfunction

function DoPostPropSetup(block)

    %Setup Dwork
    block.NumDworks                = 2;
    block.Dwork(1).Name            = 'Power_Setpoint';
    block.Dwork(1).Dimensions      = 3;
    block.Dwork(1).DatatypeID      = 0;
    block.Dwork(1).Complexity      = 'Real';
    block.Dwork(1).UsedAsDiscState = true;
    
    block.Dwork(2).Name            = 'Diagnostics';
    block.Dwork(2).Dimensions      = 3;
    block.Dwork(2).DatatypeID      = 0;
    block.Dwork(2).Complexity      = 'Real';
    block.Dwork(2).UsedAsDiscState = true;
%endfunction

function InitConditions(block)

    %Initialize Dwork
    n = block.Dwork(1).Dimensions;
    block.Dwork(1).Data(1) = 1;
    block.Dwork(1).Data(2) = 1;
    block.Dwork(1).data(3) = 1;
    
    block.Dwork(2).Data(1) = 0;
    block.Dwork(2).Data(2) = 0;
    block.Dwork(2).Data(3) = 0;

%endfunction

function Output(block)
    Preq1 = block.Dwork(1).Data(1);
    Preq2 = block.Dwork(1).Data(2);
    Preq3 = block.Dwork(1).Data(3);
    
    block.OutputPort(1).Data(1) = Preq1;
    block.OutputPort(1).Data(2) = Preq2;
    block.OutputPort(1).Data(3) = Preq3;
    
%endfunction

function Update(block)
    Pmain = block.InputPort(1).Data(1)/200;
    
    Pgen1 = block.InputPort(2).Data(1)/200;
    Pgen2 = block.InputPort(2).Data(2)/200;
    Pgen3 = block.InputPort(2).Data(3)/200;
    
    freq_com1 = block.InputPort(3).Data(1)/60;
    freq_com2 = block.InputPort(3).Data(2)/60;
    freq_com3 = block.InputPort(3).Data(3)/60;
    
    Preq1  = block.Dwork(1).Data(1);
    Preq2  = block.Dwork(1).Data(2);
    Preq3  = block.Dwork(1).Data(3);

    if (abs(Pmain)> 0.1) 
        ugrid_state = 0;        %connected
    else
        ugrid_state = 1;        %islanded
    end;
    
    if (ugrid_state==1)
        slack1 = max(0,Preq1-1);
        slack2 = max(0,Preq2-1);
        slack3 = max(0,Preq3-1);
        
        if abs(Pgen1 > 0.1)
            Preq1 = max(0,Preq1 - pi*(freq_com1-1)*Preq1-slack1);
        else
            Preq1 = 1;
        end;
        
        if abs(Pgen2 > 0.1)
            Preq2 = max(0,Preq2 - pi*(freq_com2-1)*Preq2-slack2);
        else
            Preq2 = 1;
        end;
        
        if abs(Pgen3 > 0.1)
            Preq3 = max(0,Preq3 - pi*(freq_com3-1)*Preq3-slack3);
        else
            Preq3 = 1;
        end;
     
        
    else
        Preq1 = 1;
        Preq2 = 1;
        Preq3 = 1;
        
        block.Dwork(2).Data(1) = ugrid_state;
    end;
    
    
    block.Dwork(1).Data(1) = Preq1
    block.Dwork(1).Data(2) = Preq2;
    block.Dwork(1).Data(3) = Preq3;
    
  
   

%endfunction