function trigger_box(block)
% Level-2 M file S-Function for unit delay demo.
%   Copyright 1990-2009 The MathWorks, Inc.
%   $Revision: 1.1.6.1 $ 

  setup(block);
  
%endfunction

function setup(block)
  
  block.NumDialogPrms  = 0;
 
  
  %% Register number of input and output ports
  block.NumInputPorts  = 6;
  block.NumOutputPorts = 1;

  %% Setup functional port properties to dynamically
  %% inherited.
  block.SetPreCompInpPortInfoToDynamic;
  block.SetPreCompOutPortInfoToDynamic;
 
  block.InputPort(1).Dimensions        = 1;
  block.InputPort(2).Dimensions        = 1;
  block.InputPort(3).Dimensions        = 1;
  block.InputPort(4).Dimensions        = 1;
  block.InputPort(5).Dimensions        = 1;
  block.InputPort(6).Dimensions        = 1;
  block.InputPort(1).DirectFeedthrough = false;
  block.InputPort(2).DirectFeedthrough = false;
  block.InputPort(3).DirectFeedthrough = false;
  block.InputPort(4).DirectFeedthrough = false;
  block.InputPort(5).DirectFeedthrough = false;
  block.InputPort(6).DirectFeedthrough = false;
  block.OutputPort(1).Dimensions       = 1;
  
  %% Set block sample time to inherited
  
  block.SampleTimes = [0.01 0];
  
  %% Set the block simStateCompliance to default (i.e., same as a built-in block)
  block.SimStateCompliance = 'DefaultSimState';
  

  %% Register methods
  block.RegBlockMethod('PostPropagationSetup',    @DoPostPropSetup);
  block.RegBlockMethod('InitializeConditions',    @InitConditions);  
  block.RegBlockMethod('Outputs',                 @Output);  
  block.RegBlockMethod('Update',                  @Update);  
  

  
%endfunction

function DoPostPropSetup(block)

  %% Setup Dwork
  block.NumDworks = 1;
  block.Dwork(1).Name = 'state'; 
  block.Dwork(1).Dimensions      =4;
  block.Dwork(1).DatatypeID      = 0;
  block.Dwork(1).Complexity      = 'Real';
  block.Dwork(1).UsedAsDiscState = true;

%endfunction

function InitConditions(block)

  %% Initialize Dwork
  n = block.Dwork(1).Dimensions;
  block.Dwork(1).Data(1) = 1;       %output state active
  block.Dwork(1).Data(2) = 0;       %latch state active
  block.Dwork(1).Data(3) = 0;       %timer state 0 = inactive
                                    % > 0 active.
  block.Dwork(1).Data(4) = 60.5;      %initial value for last_freq
  
  
%endfunction

function Output(block)

  output_state = block.Dwork(1).Data(1);
  block.OutputPort(1).Data = output_state;
 
 
%endfunction

function Update(block)
    
    output_state  = block.Dwork(1).Data(1);
    latch_state   = block.Dwork(1).Data(2);
    timer_state   = block.Dwork(1).Data(3);
    freq_connect     = block.Dwork(1).Data(4);
    
    reset_input   = block.InputPort(1).Data;
    freq_input    = block.InputPort(2).Data;
    current_input = block.InputPort(3).Data;
    voltage_input = block.InputPort(4).Data;
    load_priority = block.InputPort(5).Data;
    shed_load     = block.InputPort(6).Data;
    
    
    %decrement timer if nonzero
    %if timer_state is zero after update
    %  remove disconnect latch
    %  and save current frequency
    if (timer_state > 0)
        timer_state=timer_state-1;
        if (timer_state==0)
            latch_state=0;
            freq_connect = min(freq_input+shed_load/2,60.5);
            %freq_connect = 60;
            %freq_connect = min(60+shed_load/2,60.5);   %adjust assuming dispatcher brings back to 60 Hz
        end;
    end;
    
    %If reset pulse received
    %then reset program states
    %to unlatched, inactive timer, and connected
    if (reset_input==1);
        timer_state=0;
        latch_state=0;
        output_state=1;
        freq_connect = 60.5;
    end;
    
    %start the timer if the output is latched
    %and frequency is greater than 60.5
    
    
    %reconnect if the output is not latched and
    %the frequencyis greater than the connect frequency.
    
    if (latch_state == 0)&&(freq_input >= freq_connect) 
        output_state = 1;
    end;
    
        
    %switch on the type of load
    %if 1 (critical), then shed at 58.5
    %if 2 (non-critical), shed at 59.5
    switch load_priority
        case {1}
            if(latch_state==0)&&(freq_input<=58.5)&&(output_state==1)
                latch_state=1;
                output_state=0;
                timer_state = 25;
                freq_connect = 60.5;
            end;
            
        case {2}
            if(latch_state==0)&&(freq_input<=59.5)&&(output_state==1)
                latch_state=1;
                output_state=0;
                timer_state = 25;
                freq_connect = 60.5;
            end;
    end;
   

    
    block.Dwork(1).Data(1)=output_state;
    block.Dwork(1).Data(2)=latch_state;
    block.Dwork(1).Data(3)=timer_state;
    block.Dwork(1).Data(4)=freq_connect;
    
  
%endfunction

