function freq_estimator(block)
% Level-2 M file S-Function for unit delay demo.
%   Copyright 1990-2009 The MathWorks, Inc.
%   $Revision: 1.1.6.1 $ 

  setup(block);
  
%endfunction

function setup(block)
  
  block.NumDialogPrms  = 4;
 
  
  %% Register number of input and output ports
  block.NumInputPorts  = 1;
  block.NumOutputPorts = 1;

  %% Setup functional port properties to dynamically
  %% inherited.
  block.SetPreCompInpPortInfoToDynamic;
  block.SetPreCompOutPortInfoToDynamic;
 
  block.InputPort(1).Dimensions        = 1;
  block.InputPort(1).DirectFeedthrough = false;
  
  block.OutputPort(1).Dimensions       = 1;
  
  %% Set block sample time to inherited
  dt = block.DialogPrm(2).Data;
  block.SampleTimes = [dt 0];
  
  %% Set the block simStateCompliance to default (i.e., same as a built-in block)
  block.SimStateCompliance = 'DefaultSimState';
  

  %% Register methods
  block.RegBlockMethod('PostPropagationSetup',    @DoPostPropSetup);
  block.RegBlockMethod('InitializeConditions',    @InitConditions);  
  block.RegBlockMethod('Outputs',                 @Output);  
  block.RegBlockMethod('Update',                  @Update);  
  

  
%endfunction

function DoPostPropSetup(block)

  %% Setup Dwork
  block.NumDworks = 1;
  block.Dwork(1).Name = 'buffer'; 
  block.Dwork(1).Dimensions      =6;
  block.Dwork(1).DatatypeID      = 0;
  block.Dwork(1).Complexity      = 'Real';
  block.Dwork(1).UsedAsDiscState = true;

%endfunction

function InitConditions(block)

  %% Initialize Dwork
  n = block.Dwork(1).Dimensions;
  block.Dwork(1).Data = zeros(n ,1);
  
  
%endfunction

function Output(block)

  freq = block.Dwork(1).Data(4);
  block.OutputPort(1).Data = freq;
  %zcount = block.Dwork(1).Data(3);
  %block.OutputPort(1).Data = zcount;
 
%endfunction

function Update(block)
    buflen        = block.DialogPrm(1).Data;
    currentSample = block.InputPort(1).Data;
    pastSample    = block.Dwork(1).Data(1);
    icount        = block.Dwork(1).Data(2);
    zcount        = block.Dwork(1).Data(3);
    dt            = block.DialogPrm(2).Data;
    
    if (sign(currentSample) ~= sign(pastSample))
        zcount = zcount+1;
    end;
    icount = mod(icount+1,buflen);
    
    period = 2*buflen*dt;
    
    if(icount==0)
        freqraw = zcount/period;
        freq0 = block.Dwork(1).Data(4);
        freq1 = block.Dwork(1).Data(5);
        freq2 = block.Dwork(1).Data(6);
        a1 = block.DialogPrm(3).Data;
        a2 = block.DialogPrm(4).Data;
        freq  = a1*freq0 - a2*(freq1-freqraw);
        
        block.Dwork(1).Data(4) = freq;
        block.Dwork(1).Data(5) = freq0;
        block.Dwork(1).Data(6) = freq1;
        zcount = 0;
    end;
   
    
    block.Dwork(1).Data(1) = currentSample;
    block.Dwork(1).Data(2) = icount;
    block.Dwork(1).Data(3) = zcount;
    
  
%endfunction

