function smart_coupler(block)
% Level-2 M file S-Function for unit delay demo.
%   Copyright 1990-2009 The MathWorks, Inc.
%   $Revision: 1.1.6.1 $ 

  setup(block);
  
%endfunction

function setup(block)
  
  block.NumDialogPrms  = 0;
 
  
  %% Register number of input and output ports
  block.NumInputPorts  = 2;
  block.NumOutputPorts = 1;

  %% Setup functional port properties to dynamically
  %% inherited.
  block.SetPreCompInpPortInfoToDynamic;
  block.SetPreCompOutPortInfoToDynamic;
 
  block.InputPort(1).Dimensions        = 1;
  block.InputPort(2).Dimensions        = 1;
  block.InputPort(1).DirectFeedthrough = false;
  block.InputPort(2).DirectFeedthrough = false;
 
  block.OutputPort(1).Dimensions       = 1;
  
  %% Set block sample time to inherited
  
  block.SampleTimes = [-1 0];
  
  %% Set the block simStateCompliance to default (i.e., same as a built-in block)
  block.SimStateCompliance = 'DefaultSimState';
  

  %% Register methods
  block.RegBlockMethod('PostPropagationSetup',    @DoPostPropSetup);
  block.RegBlockMethod('InitializeConditions',    @InitConditions);  
  block.RegBlockMethod('Outputs',                 @Output);  
  block.RegBlockMethod('Update',                  @Update);  
  

  
%endfunction

function DoPostPropSetup(block)

  %% Setup Dwork
  block.NumDworks = 1;
  block.Dwork(1).Name = 'state'; 
  block.Dwork(1).Dimensions      =1;
  block.Dwork(1).DatatypeID      = 0;
  block.Dwork(1).Complexity      = 'Real';
  block.Dwork(1).UsedAsDiscState = true;

%endfunction

function InitConditions(block)

  %% Initialize Dwork
  n = block.Dwork(1).Dimensions;
  block.Dwork(1).Data(1) = 1;       %initial state - connected

  
  
%endfunction

function Output(block)

  switch_state = block.Dwork(1).Data(1);
  block.OutputPort(1).Data = switch_state;
 
 
%endfunction

function Update(block)
    switch_state = block.Dwork(1).Data(1);
    switch_input = block.InputPort(2).Data;
    vdiff_input  = block.InputPort(1).Data;
    
    if (switch_input==1)&(switch_state==0)&(vdiff_input<=10)
        switch_state=1;   %connect
    end;

    if (switch_input==0)&(switch_state==1)
        switch_state=0;   %disconnect
    end;
        
   
    
    block.Dwork(1).Data(1)=switch_state;
    
  
%endfunction

