function dispatcher(block)
% Level-2 M file S-Function for unit delay demo.
%   Copyright 1990-2009 The MathWorks, Inc.
%   $Revision: 1.1.6.1 $ 

  setup(block);
  
%endfunction

function setup(block)
  
  block.NumDialogPrms  = 0;
 
  
  %% Register number of input and output ports
  block.NumInputPorts  = 4;
  block.NumOutputPorts = 1;

  %% Setup functional port properties to dynamically
  %% inherited.
  block.SetPreCompInpPortInfoToDynamic;
  block.SetPreCompOutPortInfoToDynamic;
 
  block.InputPort(1).Dimensions        = 4;
  block.InputPort(2).Dimensions        = 4;
  block.InputPort(3).Dimensions        = 3;
  block.InputPort(4).Dimensions        = 3;
  block.InputPort(1).DirectFeedthrough = false;
  block.InputPort(2).DirectFeedthrough = false;
  block.InputPort(3).DirectFeedthrough = false;
  block.InputPort(4).DirectFeedthrough = false;
 
  block.OutputPort(1).Dimensions       = 3;
  
  %% Set block sample time to inherited
  
  block.SampleTimes = [0.02 0];  %readjusted from 0.01 to 0.02
  
  %% Set the block simStateCompliance to default (i.e., same as a built-in block)
  block.SimStateCompliance = 'DefaultSimState';
  

  %% Register methods
  block.RegBlockMethod('PostPropagationSetup',    @DoPostPropSetup);
  block.RegBlockMethod('InitializeConditions',    @InitConditions);  
  block.RegBlockMethod('Outputs',                 @Output);  
  block.RegBlockMethod('Update',                  @Update);  
  

  
%endfunction

function DoPostPropSetup(block)

  %% Setup Dwork
  block.NumDworks = 3;
  block.Dwork(1).Name = 'Preq'; 
  block.Dwork(1).Dimensions      =3;
  block.Dwork(1).DatatypeID      = 0;
  block.Dwork(1).Complexity      = 'Real';
  block.Dwork(1).UsedAsDiscState = true;

  
  block.Dwork(2).Name = 'PgenPast';
  block.Dwork(2).Dimensions = 3;
  block.Dwork(2).DatatypeID = 0;
  block.Dwork(2).Complexity  = 'Real';
  block.Dwork(2).UsedAsDiscState = true;
  
  block.Dwork(3).Name = 'timers';
  block.Dwork(3).Dimensions = 3;
  block.Dwork(3).DatatypeID = 0;
  block.Dwork(3).Complexity = 'Real';
  block.Dwork(3).UsedAsDiscState = true;
  
  
%endfunction

function InitConditions(block)

  %% Initialize Dwork
  n = block.Dwork(1).Dimensions;
  block.Dwork(1).Data(1) = -1/15;       %initial state - grid-connected powerlevels
  block.Dwork(1).Data(2) = 5/15;
  block.Dwork(1).Data(3) = 10/12.5;
  
  block.Dwork(2).Data(1) = 0;
  block.Dwork(2).Data(2) = 0;
  block.Dwork(2).Data(3) = 0;
  
  block.Dwork(3).Data(1) = 0;
  block.Dwork(3).Data(2) = 0;
  block.Dwork(3).Data(3) = 0;

  
  
%endfunction

function Output(block)

  block.OutputPort(1).Data = block.Dwork(1).Data;
 
 
%endfunction

function Update(block)
    %parameters
    Sbase = 15000;
    %Vbase = 208/sqrt(3);  %not needed any more
    w0=2*pi*60;
    w = .05;

    %grid state
    islandstate = block.InputPort(1).Data(1);
    connectState(1)   = block.InputPort(1).Data(2);
    connectState(2)   = block.InputPort(1).Data(3);
    connectState(3)   = block.InputPort(1).Data(4);
    
    %timers
    timer             = block.Dwork(3).Data;
    
    %get power flow on cables
    Pline      = block.InputPort(2).Data./Sbase;
    PlineLimit = [.5;.5;.5;.5];
    
    %get generator power
    Pgen      = block.InputPort(3).Data./Sbase;
    PgenPast  = block.Dwork(2).Data;
    PgenUlimit = [1;1;.8333];
    PgenLlimit = [-.1; 0 ; 0];
    Cost      = [5 0 0;0 .5 0;0 0  1];
    
    %get past Preq
    Preq = block.Dwork(1).Data;
    
    
    %get adjustment due to limit
    PmmLimit  = block.InputPort(4).Data./Sbase;
    
    %cable reactances
     Lline21 = .003300/w0;
     Lline31 = .000640/w0;
     Lline42 = .006600/w0;
     Lline43 = .004070/w0;
     
    %Incidence Matrix
    A21 = 1.0/(Lline21*w0*Sbase);
    A31 = 1.0/(Lline31*w0*Sbase);
    A42 = 1.0/(Lline42*w0*Sbase);
    A43 = 1.0/(Lline43*w0*Sbase);
    
    A = [A21 -A21 0 0;
         A31  0  -A31 0;
         0    A42  0 -A42;
         0   0    A43  -A43];
     
     
    B = [ A21+A31   -A21    -A31      0;
           -A21    A21+A42    0    -A43;
           -A31      0     A31+A43  -A42
             0      -A42     -A43   A42+A43];
     
       
     %link state    
     mu = max(0,(1/w)* (Pline-PlineLimit))+ min(0,(1/w)*(Pline+PlineLimit));
     
     %node state
     phi = Cost*Pgen + max(0,(1/w)*(Pgen-PgenUlimit))+min(0,(1/w)*(Pgen-PgenLlimit)) ;
     
     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     % compute update to power req
     
     z(1,1) = A(1,1)*mu(1)+A(2,1)*mu(2) + B(2,1)*phi(2)+B(3,1)*phi(3)+B(1,1)*phi(1);
     z(2,1) = A(1,2)*mu(1)+A(3,2)*mu(3) + B(1,2)*phi(1)+B(4,2)*phi(3)+B(2,2)*phi(2);
     z(3,1) = A(2,3)*mu(2)+A(4,3)*mu(4) + B(1,3)*phi(1)+B(4,3)*phi(3)+B(3,3)*phi(3);
    
     gam = 20;
     Pdelta = gam.*z./pi;
     Pdelta = sign(Pdelta).*min(.5,abs(Pdelta)); %was originally 0.2 pu
    
     
     for i=1:1:3;
        if(timer(i) > 0)
            timer(i) = timer(i)-1;
        end;
        if(timer(i)==0)
           if(abs(Pgen(i)-PgenPast(i)) < .1)
              Preq(i) = Pgen(i) - Pdelta(i) - PmmLimit(i);
              %Preq = Pgen - Pdelta
              Preq(i) = max(PgenLlimit(i),Preq(i));
              Preq(i) = min(PgenUlimit(i),Preq(i));
           else;
               timer(i)=15;
           end;
           if (connectState(i)==0)
             Preq(i)=0;
           end;
        end;
     end;
  
     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     
     block.Dwork(1).Data = Preq;
     block.Dwork(2).Data = Pgen;
     block.Dwork(3).Data = timer;
    
  
%endfunction

