function dispatcherES(block)
% Level-2 M file S-Function for unit delay demo.
%   Copyright 1990-2009 The MathWorks, Inc.
%   $Revision: 1.1.6.1 $ 

  setup(block);
  
%endfunction

function setup(block)
  
  block.NumDialogPrms  = 0;
 
  
  %% Register number of input and output ports
  block.NumInputPorts  = 2;
  block.NumOutputPorts = 1;

  %% Setup functional port properties to dynamically
  %% inherited.
  block.SetPreCompInpPortInfoToDynamic;
  block.SetPreCompOutPortInfoToDynamic;
 
  block.InputPort(1).Dimensions        = 2;             %serial interface  -  Pgen, freq (local)                                                    
  block.InputPort(2).Dimensions        = 2;             %wifi interface -  phi(2), connectStateES

  block.InputPort(1).DirectFeedthrough = false;
  block.InputPort(2).DirectFeedthrough = false;
 
  block.OutputPort(1).Dimensions       = 2;             %serial port output = ser->Preq,
                                                        %wifi->phi(local)
                                                        
  
  %% Set block sample time to inherited
  
  block.SampleTimes = [.01 0];  %sampling time set to 10 msec
  
  %% Set the block simStateCompliance to default (i.e., same as a built-in block)
  block.SimStateCompliance = 'DefaultSimState';
  

  %% Register methods
  block.RegBlockMethod('PostPropagationSetup',    @DoPostPropSetup);
  block.RegBlockMethod('InitializeConditions',    @InitConditions);  
  block.RegBlockMethod('Outputs',                 @Output);  
  block.RegBlockMethod('Update',                  @Update);  
  

  
%endfunction

function DoPostPropSetup(block)

  %% Setup Dwork - 
  %temp->Preq, temp->PgenPast,
  %temp->timer, temp->philocal
  block.NumDworks = 1;
  block.Dwork(1).Name = 'temp'; 
  block.Dwork(1).Dimensions      =4;
  block.Dwork(1).DatatypeID      = 0;
  block.Dwork(1).Complexity      = 'Real';
  block.Dwork(1).UsedAsDiscState = true;

  
  
%endfunction

function InitConditions(block)

  %% Initialize Dwork
  % shm->Preq
  block.Dwork(1).Data(1) = -1/15;       %initial state - grid-connected powerlevels
%  block.Dwork(1).Data(2) = 5/15;

  % shm->PgenPast
  block.Dwork(1).Data(2) = 0;
  
  % temp->timer
  block.Dwork(1).Data(3) = 0;
  
  % temp->philocal
  block.Dwork(1).Data(4) = 0;

  
  
%endfunction

function Output(block)

  %write out to serial port shm->Preq == ser->Preq
  Preq = block.Dwork(1).Data(1);
  block.OutputPort(1).Data(1) = Preq;
  philocal = block.Dwork(1).Data(4);
  block.OutputPort(1).Data(2) = philocal;
 
 
%endfunction

function Update(block)

    %compute parameters (this can be precomputed and stored).
    %parameters
    Sbase   = 15000;            %per unit power
    w0      = 2*pi*60;         %nominal frequency = 60Hz
    w       = .05;            %penalty parameter (.05)
    gam     = 20;               %step size (20)
    
    %set parameters for optimization problem
    PgenUlimit          =  1;           %for ES unit
    PgenLlimit          = -.1;          %for ES unit
    Cost              = 1;              %for ES unit
    CostGS            = 1;

    
    %cable reactances (specific to UWM grid)
     Lline21 = .003300/w0;
     Lline31 = .000640/w0;
     Lline42 = .006600/w0;
     Lline43 = .004070/w0;
     
    %Incidence Matrix
    A21 = 1.0/(Lline21*w0*Sbase);
    A31 = 1.0/(Lline31*w0*Sbase);
    A42 = 1.0/(Lline42*w0*Sbase);
    A43 = 1.0/(Lline43*w0*Sbase);
    
    %A matrix not needed since we can't access line power
    %A = [A21 -A21 0 0;
    %     A31  0  -A31 0;
    %     0    A42  0 -A42;
    %     0   0    A43  -A43];
     
     
    B = [ A21+A31   -A21    -A31      0;
           -A21    A21+A42    0    -A43;
           -A31      0     A31+A43  -A42
             0      -A42     -A43   A42+A43];
    
    %Fetch data from wireless link
    %phi(1)       = block.InputPort(1).Data(1);
    phi(2)        = block.InputPort(2).Data(1);     %MS     variable
    phi(3)        = CostGS*0.8*12.5/15;                              %Genset variable
    connectState  = block.InputPort(2).Data(2);     %ES connection state

         
    
    %Fetch data from serial link
    Pgen         = block.InputPort(1).Data(1)/Sbase;      %ser->Pgen  (local)
    freq         = block.InputPort(1).Data(2);      %ser->freq  (local)
    
    %Fetch local variables in shared memory and stored locally
    Preq         = block.Dwork(1).Data(1);          %shm->Preq
    PgenPast     = block.Dwork(1).Data(2);          %temp->PgenPast
    timer        = block.Dwork(1).Data(3);          %temp->timer

    
       
     %link state - not needed if we don't constraint line power
     %mu = max(0,(1/w)* (Pline-PlineLimit))+ min(0,(1/w)*(Pline+PlineLimit));
     
     %node state
     phi(1) = Cost*Pgen +(freq-60) + max(0,(1/2)*(Pgen-PgenUlimit)) + min(0,(1/w)*(Pgen-PgenLlimit));
     
     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     % compute update to power req
     
     
     z =  B(2,1)*phi(2)+B(3,1)*phi(3)+B(1,1)*phi(1);
     %z(2,1) = A(1,2)*mu(1)+A(3,2)*mu(3) + B(1,2)*phi(1)+B(4,2)*phi(3)+B(2,2)*phi(2);
     %z(3,1) = A(2,3)*mu(2)+A(4,3)*mu(4) + B(1,3)*phi(1)+B(4,3)*phi(3)+B(3,3)*phi(3);
    
     Pdelta = gam.*z./pi;
     Pdelta = sign(Pdelta).*min(.5,abs(Pdelta)); %was originally 0.2 pu
     
     if (timer > 0)
         timer = timer-1;
     end;
     
     if(freq <= 59.5)||(abs(Pgen-PgenPast)>=0.2)
         timer = 50;
         if connectState == 0
             Preq = .8;
         end;
     end;
     
     if (timer==0)
         if(connectState==1);
             Preq = Pgen-Pdelta;
             Preq = max(PgenLlimit,Preq);
             Preq = min(PgenUlimit,Preq);
         end;
     end;
     
 
     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
     %save shm and local variables  
     block.Dwork(1).Data(1) = Preq;        %shm->Preq
     block.Dwork(1).Data(2) = Pgen;        %temp->PgenPast
     block.Dwork(1).Data(3) = timer;       %temp->timer
     block.Dwork(1).Data(4) = phi(1);      %temp->philocal
    
  
%endfunction

