% basic generator model test program
clear
close all hidden
tic
global rho mP w0 Lgen
%nominal line frequency
w0= 2.0*pi*60;
%requested power and voltages in per unit for both generators
Ereq1 = 1;Preq1 = 0.4;Ereq2 = 1;Preq2 = 0.8;Ereq3=1;Preq3=0.6;
%filtering and limiter parameters for both generator models
Kp = 750*0.001;Ki = 750*160;Kplim = 0;Kilim = 30;tauf = 0.03;
%maximum power available from each generator in per unit
Pmax = 1.0;Pmin = 0.0; 
%more parameters for generator model
mQ = 0.05;mP =pi;
%power and voltage base values
Vbase = 208/sqrt(3);Sbase = 15000;
%load parameters
%Rload1 = 4;Lload1 = 0.001;Rload2 = 4;Rload2 = 2;Lload2 = 0.001;Lload2 = 0.002;
Rload1 = 3;Lload1 = 0.001/w0;Rload2 = 4;Lload2 = 0.001/w0;
Rload3= 6; Lload3=0.001/w0;
%frequency threshold at which each load will disconnect in Hz.
%if freq_measured<freqthresh, then the load will disconnect.
%Beware of disconnect/connect oscillations!
freqthresh1 = 0;freqthresh2 = 0;
%parameters for line that connects to grid
Vline = 208/sqrt(3);Rshunt = 10;Rline = 0.052;Lline = 0.0231/w0;
%transmission line parameters
%there are 3 busses in the system. 
%the numbers 12,13,and 23 denote bus numbers
Rline=0.000;
%Rline12 = 0.06045;Rline13 = 0.06045;Rline23 = 0.06045;
Rline12 = Rline;Rline31 = Rline;Rline23 = Rline;
Lline=0.0039/w0;
%Lline=0.01/w0;
Lline12 = Lline;Lline31 = Lline;Lline23 = Lline;
%Lline12 = 0.006045/w0;Lline13 = 0.006045/w0;Lline23 = 0.006045/w0;
%internal inductance of both generators
Lgen = 0.00188;

%%% network topollogy matrices
A_ele=1.0/( Lline*w0*Sbase/(2*Vbase*Vbase) );
A=[A_ele, -A_ele, 0;
   0, A_ele, -A_ele;
   -A_ele, 0, A_ele];
B=[2*A_ele,-A_ele,A_ele;
   -A_ele, 2*A_ele, -A_ele;
   -A_ele, -A_ele, 2*A_ele];
rho=1/sqrt(12*A_ele*A_ele);
%rho=0.0000000000000000000001;

%transmission line limits and penalties
P_lim_u=[.4,.4,.4];
P_lim_d=[-.4,-.4,-.4];
w_line=0.05;
w_u_link=[w_line;w_line;w_line];
w_d_link=[w_line;w_line;w_line];
% generator limits and penalties
Pgen_lim_u=[1.0,1.0,1.0];
Pgen_lim_d=[0.0,0.0,0.0];
w_gen=0.01;
w_u_gen=[w_gen,w_gen,w_gen];
w_d_gen=[w_gen,w_gen,w_gen];
% generator cost function a+b*p+c*p*p
gen_a=[2.0,3.0,1.0];
gen_b=[0.1,1.8,0.5];
gen_c=[0.1,0.1,0.1];
%gen_c=[0.1,0.1,0.1];
flag_trigger=0; % use event-triggered setpoint if 1
z_coef=0.00005;
tau_Preq=0.03;
t_trigger_start=3;
tstop= 15.0;
[t,x,y]= sim('microgrid_3gen_trigger',tstop);


plot_fig % plot simulation results



% run_time=toc

