
total_time=t(size(t,1)); % simulation time

% compute total generation cost
for i=1:size(t,1)
    total_cost(i)=gen_a(1)+gen_b(1)*Pmeas_1(i)+gen_c(1)*Pmeas_1(i)^2;
    total_cost(i)=total_cost(i)+gen_a(2)+gen_b(2)*Pmeas_2(i)+gen_c(2)*Pmeas_2(i)^2;
    total_cost(i)=total_cost(i)+gen_a(3)+gen_b(3)*Pmeas_3(i)+gen_c(3)*Pmeas_3(i)^2;
end

% plot total generation cost
figure(1)
plot(t,total_cost)
xlabel('t(sec)')
ylabel('cost')
title('total generation cost')

% plot measured and setpoint of active power for three generators
figure(2)
subplot(3,2,1)
plot(t,Pmeas_1)
axis([0 total_time 0 1.2])
xlabel('t(sec)')
ylabel('power(pu)')
title('Gen 1: measured P power')
subplot(3,2,3)
plot(t,Pmeas_2)
axis([0 total_time 0 1.2])
xlabel('t(sec)')
ylabel('power(pu)')
title('Gen 2: measured P power')
subplot(3,2,5)
plot(t,Pmeas_3)
axis([0 total_time 0 1.2])
xlabel('t(sec)')
ylabel('power(pu)')
title('Gen 3: measured P power')
subplot(3,2,2)
plot(t,Preq1_trigger)
axis([0 total_time 0 1.2])
xlabel('t(sec)')
ylabel('power(pu)')
title('Gen 1: setpoint P power')
subplot(3,2,4)
plot(t,Preq2_trigger)
axis([0 total_time 0 1.2])
xlabel('t(sec)')
ylabel('power(pu)')
title('Gen 2: setpoint P power')
subplot(3,2,6)
plot(t,Preq3_trigger)
axis([0 total_time 0 1.2])
xlabel('t(sec)')
ylabel('power(pu)')
title('Gen 3: setpoint P power')

% plot frequencies of three generators
figure(3)
subplot(3,1,1)
plot(t,freqgen_1)
axis([0 total_time 59.9 60.1])
xlabel('t(sec)')
ylabel('freq(Hz)')
title('Gen 1: frequency')
subplot(3,1,2)
plot(t,freqgen_2)
axis([0 total_time 59.9 60.1])
xlabel('t(sec)')
ylabel('freq(Hz)')
title('Gen 2: frequency')
subplot(3,1,3)
plot(t,freqgen_3)
axis([0 total_time 59.9 60.1])
xlabel('t(sec)')
ylabel('freq(Hz)')
title('Gen 3: frequency')

% plot load active powers
figure(4)
subplot(3,1,1)
plot(t,-PQload_1(:,1))
axis([0 total_time 0.9 1])
xlabel('t(sec)')
ylabel('power(pu)')
title('Load 1: P Power')
subplot(3,1,2)
plot(t,-PQload_2(:,1))
axis([0 total_time 0.6 0.8])
xlabel('t(sec)')
ylabel('power(pu)')
title('Load 2: P Power')
subplot(3,1,3)
plot(t,-PQload_3(:,1))
axis([0 total_time 0 0.5])
xlabel('t(sec)')
ylabel('power(pu)')
title('Load 3: P Power')

% plot transmission line active powers
figure(5)
subplot(3,1,1)
plot(t,PQline_12(:,1))
axis([0 total_time -0.5 0.3])
xlabel('t(sec)')
ylabel('power(pu)')
title('Line 12: P Power')
subplot(3,1,2)
plot(t,PQline_23(:,1))
axis([0 total_time 0.1 0.7])
xlabel('t(sec)')
ylabel('power(pu)')
title('Line 23: P Power')
subplot(3,1,3)
plot(t,PQline_31(:,1))
axis([0 total_time -0.5 0.1])
xlabel('t(sec)')
ylabel('power(pu)')
title('Line 31: P Power')

% plot broadcast period of generators
figure(6)
subplot(3,1,1)
plot(t,tsamp_1)
axis([0 total_time 0 5])
xlabel('t(sec)')
ylabel('time since last broadcast(sec)')
title('Gen 1: broadcast period')
subplot(3,1,2)
plot(t,tsamp_2)
axis([0 total_time 0 6])
xlabel('t(sec)')
ylabel('time since last broadcast(sec)')
title('Gen 2: broadcast period')
subplot(3,1,3)
plot(t,tsamp_3)
axis([0 total_time 0 12])
xlabel('t(sec)')
ylabel('time since last broadcast(sec)')
title('Gen 3: broadcast period')

